<?php
session_start();
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("Location: index.php");
    exit;
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta name="robots" content="noindex">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Landing Page</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        /* Custom CSS for button styling and layout */
        body, html {
            height: 100%;
            margin: 0;
            font-family: Arial, sans-serif;
        }

        .container {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100vh;
            text-align: center;
            background-color: #f7f7f7;
        }

        .btn-custom {
            width: 100%;
            max-width: 300px;
            margin: 15px 0;
            padding: 15px;
            font-size: 18px;
            font-weight: bold;
            text-transform: uppercase;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s;
        }

        .btn-custom:hover {
            transform: translateY(-5px);
        }

        /* Adjust for smaller devices */
        @media (max-width: 768px) {
            .btn-custom {
                font-size: 16px;
            }
        }

        /* Colors for buttons */
        .btn-register { background-color: #4CAF50; color: white; }
        .btn-loan-app { background-color: #2196F3; color: white; }
        .btn-loan-collection { background-color: #FFC107; color: black; }
        .btn-daily-records { background-color: #FF5722; color: white; }
        .btn-loan-statement { background-color: #673AB7; color: white; } /* New button color */
    </style>
</head>
<body>

<div class="container">
    <h1 class="mb-5">Loan Management System</h1>

    <!-- Register New Member Button -->
    <a href="registration.php" class="btn btn-custom btn-register">Register New Member</a>

    <!-- Loan Application Button -->
    <a href="loan_application.php" class="btn btn-custom btn-loan-app">Loan Application</a>

    <!-- Loan Collection Button -->
    <a href="collection1.php" class="btn btn-custom btn-loan-collection">Loan Collection</a>

    <!-- Daily Records Display Button -->
    <a href="displaydata/phone_collection_display2.php" class="btn btn-custom btn-daily-records">Daily Records Display</a>

    <!-- New Loan Collection Statement Button -->
    <a href="loan_statement.php" class="btn btn-custom btn-loan-statement">Loan Statement</a>
	
	 <!-- Loan Collection Button -->
    <a href="logout.php" class="btn btn-custom btn-loan-collection">Log Out</a>

</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
