<?php
session_start();
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("Location: index.php");
    exit;
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register Loan for Member</title>
    <!-- Bootstrap CSS for responsive design -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .container {
            margin-top: 50px;
            background-color: #fff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .form-label {
            font-weight: bold;
        }
        .alert {
            display: none;
        }
        .btn-back {
            margin-top: 20px;
        }
    </style>
</head>
<body>

<div class="container">
    <h2 class="text-center mb-4">Register Loan for Member</h2>
    
    <!-- Alert for Active Loan -->
    <div id="loanAlert" class="alert alert-warning" role="alert">
        Member still has an active loan. Cannot register a new loan.
    </div>

    <form action="register_loan.php" method="POST" id="loanForm">
        <div class="mb-3">
            <label for="memberID" class="form-label">Member ID</label>
            <input type="number" class="form-control" id="memberID" name="memberID" placeholder="Enter Member ID" required>
        </div>

        <div class="mb-3">
            <label for="memberName" class="form-label">Member Name</label>
            <input type="text" class="form-control" id="memberName" name="memberName" placeholder="Member Name" readonly>
        </div>

        <div class="mb-3">
            <label for="amount" class="form-label">Loan Amount</label>
            <input type="number" class="form-control" id="amount" name="amount" placeholder="Enter Loan Amount" required>
        </div>

        <div class="mb-3">
            <label for="formFee" class="form-label">Form Fee (5%)</label>
            <input type="text" class="form-control" id="formFee" name="form_fee" readonly>
        </div>

        <div class="mb-3">
            <label for="interest" class="form-label">Interest (20%)</label>
            <input type="text" class="form-control" id="interest" name="interest" readonly>
        </div>

        <div class="mb-3">
            <label for="totalLoan" class="form-label">Total Loan</label>
            <input type="text" class="form-control" id="totalLoan" name="TotalLoan" readonly>
        </div>

        <div class="mb-3">
            <label for="loanDate" class="form-label">Loan Date</label>
            <input type="date" class="form-control" id="loanDate" name="loanDate" required>
        </div>

        <div class="mb-3">
            <label for="loanEndDate" class="form-label">Loan End Date (36 days later)</label>
            <input type="date" class="form-control" id="loanEndDate" name="loanEndDate" readonly>
        </div>

        <button type="submit" class="btn btn-primary w-100" id="submitBtn">Register Loan</button>
    </form>

    <!-- Back to Main Page Button -->
    <a href="home.php" class="btn btn-secondary w-100 btn-back">Back to Main Page</a>
</div>

<!-- Bootstrap JS for responsiveness -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<!-- jQuery for AJAX -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
$(document).ready(function() {
    // Function to format numbers with commas
    function formatCurrency(value) {
        return value.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }

    // Function to remove commas and decimals before submission
    function removeFormatting(value) {
        return value.replace(/,/g, '').split('.')[0];
    }

    // When the user enters the Member ID
    $('#memberID').on('input', function() {
        var memberID = $(this).val();
        
        if (memberID !== "") {
            $.ajax({
                url: 'fetch_member_loan_status.php',  
                method: 'POST',
                data: { memberNo: memberID },
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'success') {
                        $('#memberName').val(response.memberName);
                        $('#loanAlert').hide();
                        $('#submitBtn').prop('disabled', false);
                    } else {
                        $('#memberName').val('');
                        $('#loanAlert').text(response.message).show();
                        $('#submitBtn').prop('disabled', true);
                    }
                },
                error: function() {
                    alert('Error fetching member details. Please try again.');
                }
            });
        } else {
            $('#memberName').val('');
            $('#loanAlert').hide();
            $('#submitBtn').prop('disabled', false);
        }
    });

    // Calculate Form Fee, Interest, and Total Loan when the amount is entered
    $('#amount').on('input', function() {
        var amount = parseFloat($(this).val()) || 0;
        var formFee = amount * 0.05;
        var interest = amount * 0.20;
        var totalLoan = amount + interest;

        $('#formFee').val(formatCurrency(formFee));
        $('#interest').val(formatCurrency(interest));
        $('#totalLoan').val(formatCurrency(totalLoan));
    });

    // Calculate Loan End Date (+36 days)
    $('#loanDate').on('change', function() {
        const loanDate = new Date($(this).val());
        if (!isNaN(loanDate)) {
            loanDate.setDate(loanDate.getDate() + 36);
            const yyyy = loanDate.getFullYear();
            const mm = String(loanDate.getMonth() + 1).padStart(2, '0');
            const dd = String(loanDate.getDate()).padStart(2, '0');
            const endDateFormatted = `${yyyy}-${mm}-${dd}`;
            $('#loanEndDate').val(endDateFormatted);
        }
    });

    // Before form submission, remove formatting from specific fields
    $('#loanForm').on('submit', function() {
        $('#formFee').val(removeFormatting($('#formFee').val()));
        $('#interest').val(removeFormatting($('#interest').val()));
        $('#totalLoan').val(removeFormatting($('#totalLoan').val()));
    });
});
</script>

</body>
</html>
